package ru.yandex.mail.micronaut.common;

import lombok.AllArgsConstructor;
import one.util.streamex.EntryStream;

import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

@AllArgsConstructor
public class IterableStream<T> implements Iterable<T> {
    private final Supplier<Stream<T>> streamSupplier;

    public <K, V> IterableStream(Map<K, V> map, Function<EntryStream<K, V>, Stream<T>> conv) {
        this(() -> conv.apply(EntryStream.of(map)));
    }

    @Override
    public Iterator<T> iterator() {
        return streamSupplier.get().iterator();
    }
}
