package ru.yandex.mail.micronaut.common;

import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;

import javax.inject.Singleton;

@Factory
public class JacksonModuleFactory {
    @Bean
    @Singleton
    Jdk8Module jdk8Module() {
        return new Jdk8Module();
    }

    @Bean
    @Singleton
    JavaTimeModule javaTimeModule() {
        return new JavaTimeModule();
    }

    @Bean
    @Singleton
    ParameterNamesModule parameterNamesModule() {
        return new ParameterNamesModule();
    }
}
