package ru.yandex.mail.micronaut.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.env.PropertySourceLoader;
import io.micronaut.core.io.ResourceLoader;

import javax.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;

import static io.micronaut.jackson.JacksonConfiguration.PROPERTY_USE_BEAN_INTROSPECTION;

public class JacksonPropertySourceLoader implements PropertySourceLoader {
    private static final Map<String, Object> PROPERTIES = Map.of(
        PROPERTY_USE_BEAN_INTROSPECTION, false,
        "jackson.serializationInclusion", JsonInclude.Include.ALWAYS.name(),
        "jackson.serialization.writeDatesAsTimestamps", false,
        "jackson.mapper.acceptCaseInsensitiveEnums", true,
        "jackson.deserialization.failOnNullForPrimitives", true,
        "jackson.deserialization.failOnNullCreatorProperties", true
    );

    @Override
    @Deprecated
    public Optional<PropertySource> load(String resourceName, ResourceLoader resourceLoader,
                                         @Nullable String environmentName) {
        return Optional.of(PropertySource.of(PROPERTIES));
    }

    @Override
    public Map<String, Object> read(String name, InputStream input) throws IOException {
        return PROPERTIES;
    }
}
