package ru.yandex.mail.micronaut.common;

import lombok.EqualsAndHashCode;

import java.util.function.Supplier;

@EqualsAndHashCode
public class Lazy<T> {
    private static final Object UNINITIALIZED = new Object();

    @SuppressWarnings("unchecked")
    private volatile T value = (T) UNINITIALIZED;

    public T getOrCompute(Supplier<T> computer) {
        if (value == UNINITIALIZED) {
            synchronized (this) {
                if (value == UNINITIALIZED) {
                    value = computer.get();
                }
            }
        }

        return value;
    }

    @Override
    public String toString() {
        return value == UNINITIALIZED ? "uninitialized" : String.valueOf(value);
    }
}
