package ru.yandex.mail.micronaut.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.micronaut.core.annotation.Introspected;
import lombok.AllArgsConstructor;
import lombok.Value;

import javax.validation.constraints.Positive;
import java.util.Optional;
import java.util.function.Function;

@Value
@Introspected
@AllArgsConstructor(onConstructor_= @JsonCreator)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class Pageable<ID> {
    Optional<ID> pageId;
    @Positive int pageSize;

    public Pageable(ID pageId, int pageSize) {
        this(Optional.of(pageId), pageSize);
    }

    public static <ID> Pageable<ID> first(int pageSize) {
        return new Pageable<>(Optional.empty(), pageSize);
    }

    public <ID2> Pageable<ID2> map(Function<ID, ID2> mapper) {
        return new Pageable<>(pageId.map(mapper), pageSize);
    }
}
