package ru.yandex.mail.micronaut.common;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.micronaut.core.annotation.Introspected;
import lombok.Value;

import java.io.IOException;

class RawJsonStringSerializer extends JsonSerializer<RawJsonString> {
    @Override
    public void serialize(RawJsonString value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeRawValue(value.getValue());
    }
}

class RawJsonStringDeserializer extends JsonDeserializer<RawJsonString> {
    @Override
    public RawJsonString deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
        return new RawJsonString(p.readValueAsTree().toString());
    }
}

@Value
@Introspected
@JsonSerialize(using = RawJsonStringSerializer.class)
@JsonDeserialize(using = RawJsonStringDeserializer.class)
public class RawJsonString {
    String value;

    @Override
    public String toString() {
        return value;
    }
}
