package ru.yandex.mail.micronaut.common.context;

import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import lombok.val;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

import static ru.yandex.mail.micronaut.common.context.ContextManager.REQUEST_ID_HEADER;

@Filter("/**")
class TracingHttpServerFilter implements HttpServerFilter {
    @Override
    public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        val requestId = ContextManager.setInformationFrom(request);

        return Mono.from(chain.proceed(request))
            .doOnNext(response -> response.getHeaders().add(REQUEST_ID_HEADER, requestId));
    }
}
