package ru.yandex.mail.micronaut.common.thread_factory;

import javax.annotation.Nonnull;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class NamedThreadFactory implements ThreadFactory {
    private final String namePrefix;
    private final AtomicLong counter;

    public NamedThreadFactory(String namePrefix) {
        this.namePrefix = namePrefix;
        this.counter = new AtomicLong(0L);
    }

    private String createName() {
        return namePrefix + '-' + counter.getAndIncrement();
    }

    @Override
    public Thread newThread(@Nonnull Runnable r) {
        return new Thread(null, r, createName(), 0);
    }
}
