package ru.yandex.mail.micronaut.common.validation;

import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.validation.validator.constraints.ConstraintValidator;

import javax.inject.Singleton;
import javax.validation.constraints.Negative;
import javax.validation.constraints.Positive;
import javax.validation.constraints.PositiveOrZero;
import java.time.Duration;

@Factory
public class ExtraValidatorFactory {
    @Bean
    @Singleton
    public ConstraintValidator<Positive, Duration> positiveDurationValidator() {
        return (value, annotationMetadata, context) -> value == null || !(value.isNegative() || value.isZero());
    }

    @Bean
    @Singleton
    public ConstraintValidator<PositiveOrZero, Duration> positiveOrZeroDurationValidator() {
        return (value, annotationMetadata, context) -> value == null || !value.isNegative();
    }

    @Bean
    @Singleton
    public ConstraintValidator<Negative, Duration> negativeDurationValidator() {
        return (value, annotationMetadata, context) -> value == null || value.isNegative();
    }
}
