SET(JACKSON_VERSION 2.10.1)
SET(JDBI_VERSION 3.12.2)
SET(LOG4J_VERSION 2.11.2) # see https://issues.apache.org/jira/browse/LOG4J2-2652
SET(MICRONAUT_VERSION 1.3.3)
SET(NETTY_VERSION 4.1.47.Final)
SET(SPRING_VERSION 5.2.3.RELEASE)
SET(EA_ASYNC_VERSION 1.2.2)
SET(EA_ASYNC_AGENT_PATH ${ARCADIA_BUILD_ROOT}/contrib/java/com/ea/async/ea-async/${EA_ASYNC_VERSION}/ea-async-${EA_ASYNC_VERSION}.jar)

# testing
SET(JUNIT_VERSION 5.5.2)
SET(MOCKITO_VERSION 2.24.0)
SET(CUCUMBER_VERSION 5.1.3)
SET(JSON_UNIT_VERSION 2.7.0)

INCLUDE(${ARCADIA_ROOT}/contrib/java/io/micronaut/micronaut-bom/${MICRONAUT_VERSION}/ya.dependency_management.inc)
INCLUDE(${ARCADIA_ROOT}/contrib/java/org/junit/junit-bom/${JUNIT_VERSION}/ya.dependency_management.inc)
INCLUDE(${ARCADIA_ROOT}/contrib/java/io/netty/netty-bom/${NETTY_VERSION}/ya.dependency_management.inc)
INCLUDE(${ARCADIA_ROOT}/contrib/java/org/springframework/spring-framework-bom/${SPRING_VERSION}/ya.dependency_management.inc)
INCLUDE(${ARCADIA_ROOT}/contrib/java/com/fasterxml/jackson/jackson-bom/${JACKSON_VERSION}/ya.dependency_management.inc)
INCLUDE(${ARCADIA_ROOT}/contrib/java/org/apache/logging/log4j/log4j-bom/${LOG4J_VERSION}/ya.dependency_management.inc)
INCLUDE(${ARCADIA_ROOT}/contrib/java/org/jdbi/jdbi3-bom/${JDBI_VERSION}/ya.dependency_management.inc)

DEPENDENCY_MANAGEMENT(
    contrib/java/org/projectlombok/lombok/1.18.22
    contrib/java/one/util/streamex/0.7.2
    contrib/java/org/postgresql/postgresql/42.2.9
    contrib/java/com/ea/async/ea-async/${EA_ASYNC_VERSION}
    contrib/java/org/slf4j/slf4j-api/1.7.30
    contrib/java/io/projectreactor/reactor-core/3.3.1.RELEASE
    contrib/java/io/projectreactor/addons/reactor-extra/3.3.0.RELEASE
    contrib/java/net/bytebuddy/byte-buddy/1.10.6
    contrib/java/com/zaxxer/HikariCP/3.4.2
    contrib/java/io/micrometer/micrometer-core/1.3.3
    contrib/java/com/lmax/disruptor/3.4.2
    contrib/java/org/yaml/snakeyaml/1.24
    contrib/java/org/reactivestreams/reactive-streams/1.0.3
    contrib/java/org/reactivestreams/reactive-streams-tck/1.0.3
    contrib/java/org/jetbrains/annotations/19.0.0

    # testing
    contrib/java/org/mockito/mockito-core/${MOCKITO_VERSION}
    contrib/java/org/mockito/mockito-junit-jupiter/${MOCKITO_VERSION}

    contrib/java/org/assertj/assertj-core/3.14.0
    contrib/java/org/awaitility/awaitility/3.1.6

    contrib/java/net/javacrumbs/json-unit/json-unit/${JSON_UNIT_VERSION}
    contrib/java/net/javacrumbs/json-unit/json-unit-core/${JSON_UNIT_VERSION}
    contrib/java/net/javacrumbs/json-unit/json-unit-assertj/${JSON_UNIT_VERSION}
    contrib/java/net/javacrumbs/json-unit/json-unit-json-path/${JSON_UNIT_VERSION}
    contrib/java/net/javacrumbs/json-unit/json-unit-fluent/${JSON_UNIT_VERSION}

    contrib/java/io/cucumber/cucumber-java/${CUCUMBER_VERSION}
    contrib/java/io/cucumber/cucumber-junit/${CUCUMBER_VERSION}
    contrib/java/io/cucumber/cucumber-spring/${CUCUMBER_VERSION}
)

PEERDIR(
    contrib/java/org/jetbrains/annotations
)

EXCLUDE(
    contrib/java/org/checkerframework/checker-qual
    contrib/java/com/google/errorprone/error_prone_annotations
)
