### Описание

Данная библиотека позволяет включить настраиваемое логирование для HTTP клиентов и сервера. По-умолчанию логирование производится через **slf4j**, для использования **log4j2** необходимо подключить **http_logger_log4j2**, который использует garbage-free возможности **log4j2**. 
Имеется возможность сконфигурировать сервер и каждый клиент в отдельности. Для сервера необходимо добавить секцию **logging** в конфиг **micronaut.server**.
Для клиента необходимо добавить секцию **logging** в конфиг **micronaut.http.services.<service-id>.logging**.

#### Формат конфига:

```yaml
logging:
  enabled: true # включить/выключить логирование
  log-request-params: true # включить/выключить логирование параметров запроса
  log-request-body: true # включить/выключить логирование тела запроса (если тело присутствует в запросе)
  log-request-headers: true # включить/выключить логирование заголовков запроса
  log-response-body: true # включить/выключить логирование тела ответа (если тело присутствует в ответе)
  log-response-headers: true # включить/выключить логирование заголовков ответа
  sensitive-headers: [X-Sensitive] # позволяет указать список `sensitive` заголовков запроса или ответа, значение которых не будет записано в лог
  sensitive-params: [password] # позволяет указать список `sensitive` параметров запроса, значение которых не будет записано в лог
```
