package ru.yandex.mail.micronaut.http_logger.http_logger_log4j2;

import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import org.apache.logging.log4j.LogManager;
import ru.yandex.mail.micronaut.http_logger.RequestLogger;
import ru.yandex.mail.micronaut.http_logger.RequestLoggerFactory;
import ru.yandex.mail.micronaut.http_logger.config.LoggingOptions;

import javax.inject.Singleton;

@Singleton
@Requires(classes = LogManager.class)
@Replaces(RequestLoggerFactory.class)
public class Log4j2RequestLoggerFactory implements RequestLoggerFactory {
    @Override
    public RequestLogger createLogger(String loggerName, LoggingOptions config) {
        return new Log4j2RequestLogger(loggerName, config);
    }
}
