package ru.yandex.mail.micronaut.http_logger;

import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpHeaders;
import lombok.experimental.UtilityClass;

import java.util.List;
import java.util.Set;

import static java.util.Collections.singletonList;

@UtilityClass
public class Constants {
    public static final Set<String> DEFAULT_SENSITIVE_HEADERS = Set.of(
        HttpHeaders.AUTHORIZATION,
        HttpHeaders.PROXY_AUTHORIZATION,
        "X-Ya-Service-Ticket",
        "X-Ya-User-Ticket"
    );

    public static final String CUT = "<cut>";
    public static final List<String> CUT_LIST = singletonList(CUT);

    public static final String BODY_DELIMITER = "----";

    public static final Argument<String> STRING_ARGUMENT = Argument.of(String.class);
}
