package ru.yandex.mail.micronaut.http_logger;

import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;

public interface RequestLogger {
    <B> void logRequest(HttpRequest<B> request, String action);

    <B> void logResponse(HttpMethod requestMethod, String requestPath, HttpResponse<B> response);

    void logResponse(HttpMethod requestMethod, String requestPath, Throwable e);
}
