package ru.yandex.mail.micronaut.http_logger.client;

import one.util.streamex.StreamEx;
import ru.yandex.mail.micronaut.http_logger.RequestLogger;
import ru.yandex.mail.micronaut.http_logger.RequestLoggerFactory;
import ru.yandex.mail.micronaut.http_logger.config.ClientLoggingConfiguration;
import ru.yandex.mail.micronaut.http_logger.config.LoggingOptions;

import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Singleton
class ClientLoggerManager {
    private final Map<String, RequestLogger> loggers;

    private static Optional<RequestLogger> createLogger(RequestLoggerFactory factory, String clientId,
                                                        LoggingOptions loggingOptions) {
        if (loggingOptions.isEnabled()) {
            return Optional.of(factory.createLogger(clientId, loggingOptions));
        } else {
            return Optional.empty();
        }
    }

    @Inject
    public ClientLoggerManager(RequestLoggerFactory factory, List<ClientLoggingConfiguration> configurations) {
        this.loggers = StreamEx.of(configurations)
            .mapToEntry(ClientLoggingConfiguration::getClientId, ClientLoggingConfiguration::getOptions)
            .flatMapValues(StreamEx::of)
            .mapToValue((clientId, options) -> createLogger(factory, clientId, options))
            .flatMapValues(StreamEx::of)
            .toImmutableMap();
    }

    @Nullable RequestLogger findLogger(String clientId) {
        return loggers.get(clientId);
    }
}
