package ru.yandex.mail.micronaut.http_logger.client;

import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.ClientFilterChain;
import io.micronaut.http.filter.HttpClientFilter;
import lombok.AllArgsConstructor;
import lombok.val;
import org.reactivestreams.Publisher;

import javax.inject.Inject;

@Filter("/**")
@AllArgsConstructor(onConstructor_=@Inject)
public class HttpClientRequestLoggingFilter implements HttpClientFilter {
    private void filter(String clientId, MutableHttpRequest<?> request) {
        val logger = manager.findLogger(clientId);

        if (logger == null) {
            return;
        }

        logger.logRequest(request, "Sending");
    }

    private final ClientLoggerManager manager;

    @Override
    public Publisher<? extends HttpResponse<?>> doFilter(MutableHttpRequest<?> request, ClientFilterChain chain) {
        request.getAttribute(HttpAttributes.SERVICE_ID, String.class)
            .ifPresent(clientId -> filter(clientId, request));
        return chain.proceed(request);
    }

    @Override
    public int getOrder() {
        return LOWEST_PRECEDENCE;
    }
}
