package ru.yandex.mail.micronaut.http_logger.config;

import io.micronaut.context.annotation.ConfigurationInject;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.http.client.ServiceHttpClientConfiguration;
import lombok.Getter;
import lombok.Value;

import javax.annotation.Nullable;
import java.util.Optional;
import java.util.Set;

@Getter
@EachProperty(ServiceHttpClientConfiguration.PREFIX)
public final class ClientLoggingConfiguration {
    private final String clientId;
    private final Optional<Options> options;

    @ConfigurationInject
    public ClientLoggingConfiguration(@Parameter String clientId, @Nullable Options options) {
        this.clientId = clientId;
        this.options = Optional.ofNullable(options);
    }

    @Value
    @ConfigurationProperties("logging")
    @SuppressWarnings("RedundantModifiersValueLombok") // micronaut doesn't see lombok-generated 'private final'
    public static class Options implements LoggingOptions {
        private final boolean enabled;
        private final boolean logRequestParams;
        private final boolean logRequestBody;
        private final boolean logRequestHeaders;
        private final boolean logResponseBody;
        private final boolean logResponseHeaders;
        @Nullable private final Set<String> sensitiveHeaders;
        @Nullable private final Set<String> sensitiveParams;

        @ConfigurationInject
        public Options(boolean enabled, boolean logRequestParams, boolean logRequestBody, boolean logRequestHeaders,
                       boolean logResponseBody, boolean logResponseHeaders, @Nullable Set<String> sensitiveHeaders,
                       @Nullable Set<String> sensitiveParams) {
            this.enabled = enabled;
            this.logRequestParams = logRequestParams;
            this.logRequestBody = logRequestBody;
            this.logRequestHeaders = logRequestHeaders;
            this.logResponseBody = logResponseBody;
            this.logResponseHeaders = logResponseHeaders;
            this.sensitiveHeaders = sensitiveHeaders;
            this.sensitiveParams = sensitiveParams;
        }
    }
}
