package ru.yandex.mail.micronaut.http_logger.config;

import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.util.Toggleable;

import javax.annotation.Nullable;
import java.util.Set;

public interface LoggingOptions extends Toggleable {
    @Bindable(defaultValue = "true")
    boolean isLogRequestParams();

    @Bindable(defaultValue = "false")
    boolean isLogRequestBody();

    @Bindable(defaultValue = "true")
    boolean isLogRequestHeaders();

    @Bindable(defaultValue = "false")
    boolean isLogResponseBody();

    @Bindable(defaultValue = "true")
    boolean isLogResponseHeaders();

    @Nullable Set<String> getSensitiveHeaders();

    @Nullable Set<String> getSensitiveParams();
}
