package ru.yandex.mail.micronaut.http_logger.message;

import com.fasterxml.jackson.databind.JsonNode;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.http.HttpMessage;
import lombok.experimental.UtilityClass;

import java.util.Optional;

import static ru.yandex.mail.micronaut.http_logger.Constants.STRING_ARGUMENT;

@UtilityClass
class BodyExtractor {
    <B> String extractBody(HttpMessage<B> message) {
        message.getBody(String.class);
        return message.getBody()
            .flatMap(body -> {
                if (body instanceof JsonNode) {
                    return Optional.of(body.toString());
                } else {
                    return ConversionService.SHARED.convert(body, ConversionContext.of(STRING_ARGUMENT));
                }
            })
            .orElse("");
    }
}
