package ru.yandex.mail.micronaut.http_logger.message;

import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import lombok.Value;
import ru.yandex.mail.micronaut.http_logger.config.LoggingOptions;

import java.util.List;
import java.util.Map;

import static java.util.Collections.emptyMap;

@Value
public class RequestMessage {
    HttpMethod method;
    String path;
    String action;
    Map<String, List<String>> params;
    Map<String, List<String>> headers;
    String body;

    public RequestMessage(LoggingOptions config, HttpRequest<?> request, String action) {
        this.method = request.getMethod();
        this.path = request.getPath();
        this.action = action;
        this.params = config.isLogRequestParams() ? request.getParameters().asMap() : emptyMap();
        this.headers = config.isLogRequestHeaders() ? request.getHeaders().asMap() : emptyMap();
        this.body = config.isLogRequestBody() ? BodyExtractor.extractBody(request) : "";
    }
}
