package ru.yandex.mail.micronaut.http_logger.message;

import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import lombok.Value;
import ru.yandex.mail.micronaut.http_logger.config.LoggingOptions;

import java.util.List;
import java.util.Map;

import static java.util.Collections.emptyMap;

@Value
public class ResponseMessage {
    HttpMethod requestMethod;
    String requestPath;
    HttpStatus status;
    Map<String, List<String>> headers;
    String body;

    public ResponseMessage(LoggingOptions config, HttpMethod requestMethod, String requestPath, HttpResponse<?> response) {
        this.requestMethod = requestMethod;
        this.requestPath = requestPath;
        this.status = response.getStatus();
        this.headers = config.isLogResponseHeaders() ? response.getHeaders().asMap() : emptyMap();
        this.body = config.isLogResponseBody() ? BodyExtractor.extractBody(response) : "";
    }
}
