package ru.yandex.mail.micronaut.http_logger.server;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import org.reactivestreams.Publisher;
import ru.yandex.mail.micronaut.http_logger.RequestLogger;
import ru.yandex.mail.micronaut.http_logger.RequestLoggerFactory;
import ru.yandex.mail.micronaut.http_logger.config.ServerLoggingConfiguration;

import javax.inject.Inject;

@Filter("/**")
@Requires(property = ServerLoggingConfiguration.PREFIX)
public class HttpServerRequestLoggingFilter implements HttpServerFilter {
    static final String LOG_NAME = "server";

    private final RequestLogger logger;

    @Inject
    public HttpServerRequestLoggingFilter(RequestLoggerFactory factory, ServerLoggingConfiguration configuration) {
        this.logger = factory.createLogger(LOG_NAME, configuration);
    }

    @Override
    public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        logger.logRequest(request, "Receiving");
        return chain.proceed(request);
    }

    @Override
    public int getOrder() {
        return LOWEST_PRECEDENCE;
    }
}
