package ru.yandex.mail.micronaut.http_logger.server;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import lombok.val;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import ru.yandex.mail.micronaut.http_logger.RequestLogger;
import ru.yandex.mail.micronaut.http_logger.RequestLoggerFactory;
import ru.yandex.mail.micronaut.http_logger.config.ServerLoggingConfiguration;

import javax.inject.Inject;

import static ru.yandex.mail.micronaut.http_logger.server.HttpServerRequestLoggingFilter.LOG_NAME;

@Filter("/**")
@Requires(property = ServerLoggingConfiguration.PREFIX)
public class HttpServerResponseLoggingFilter implements HttpServerFilter {
    private final RequestLogger logger;

    @Inject
    public HttpServerResponseLoggingFilter(RequestLoggerFactory factory, ServerLoggingConfiguration configuration) {
        this.logger = factory.createLogger(LOG_NAME, configuration);
    }

    @Override
    public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        val method = request.getMethod();
        val path = request.getPath();

        return Mono.from(chain.proceed(request))
            .doOnError(e -> logger.logResponse(method, path, e))
            .doOnSuccess(response -> logger.logResponse(method, path, response));
    }

    @Override
    public int getOrder() {
        return HIGHEST_PRECEDENCE;
    }
}
