package ru.yandex.mail.micronaut.http_logger.slf4j;

import ru.yandex.mail.micronaut.http_logger.RequestLogger;
import ru.yandex.mail.micronaut.http_logger.RequestLoggerFactory;
import ru.yandex.mail.micronaut.http_logger.config.LoggingOptions;

import javax.inject.Singleton;

@Singleton
public class Slf4jRequestLoggerFactory implements RequestLoggerFactory {
    @Override
    public RequestLogger createLogger(String loggerName, LoggingOptions config) {
        return new Slf4JRequestLogger(loggerName, config);
    }
}
