JUNIT5()

JDK_VERSION(11)

OWNER(
    g:fininfra
)

INCLUDE(${ARCADIA_ROOT}/mail/micronaut/dependency_versions.inc)
INCLUDE(${ARCADIA_ROOT}/mail/micronaut/micronaut_http_server.inc)
INCLUDE(${ARCADIA_ROOT}/mail/micronaut/test_deps.inc)

IF (SANITIZER_TYPE)
    TAG(ya:not_autocheck)
ENDIF()

JAVAC_FLAGS(
    -parameters
    -Xlint:unchecked
)

NO_LINT()
SIZE(medium)

JAVA_SRCS(SRCDIR ${ARCADIA_ROOT}/mail/micronaut/http_logger/src/test/java **/*)
JAVA_SRCS(RESOURCES SRCDIR ${ARCADIA_ROOT}/mail/micronaut/http_logger/src/test/resources **/*)

PEERDIR(
    mail/micronaut/http_logger
    mail/micronaut/http_logger/http_logger_log4j2
    contrib/java/io/micronaut/test/micronaut-test-junit5
    contrib/java/org/apache/logging/log4j/log4j-core-tests/${LOG4J_VERSION}
)

ANNOTATION_PROCESSOR(
    lombok.launch.AnnotationProcessorHider$AnnotationProcessor
    io.micronaut.annotation.processing.TypeElementVisitorProcessor
    io.micronaut.annotation.processing.PackageConfigurationInjectProcessor
    io.micronaut.annotation.processing.BeanDefinitionInjectProcessor
)

END()
