### Описание

Данная библиотека позволяет включить сбор метрик и их выдачу в stat ручку. Метрики собираются при помощи интеграции **micrometer** в **micronaut**.
На текущий момент поддерживается станартный набор метрик, которые из коробки предоставляет **micronaut**. Как включить те или иные метрики можно посмотреть [здесь](https://micronaut-projects.github.io/micronaut-micrometer/latest/guide/). Для того чтобы добавить собственные метрики необходимо использовать MeterRegistry из контекста **micronaut**. 

Помимо стандартных параметров метрик в **micronaut** модуль предоставляет дополнительный набор опций, которые можно задать в секции **unistat** вашего конфига. Все параметры опциональны и по-умолчанию настроены как в календаре.

```yaml
unistat:
  expiry: 1s|2ms|2h...|Nd # см. DistributionStatisticConfig.expiry (default = 1m)
  buffer-length: # см. DistributionStatisticConfig.bufferLength (default = 1000)
  default-sla: [1ms, 10ms, 1s, ..., Nms] # Описание бакетов гистограмм (default = смотри в коде :))
  sla: [...] # Специализированные параметры бакетов гистрограмм (подробности ниже)
```

Параметр **sla** позволяет настривать бакеты гиcтограмм для конкретных метрик. В списке задается набор конфигураций следующего вида:
```yaml
unistat:
  ...
  sla:
    name1:
      metric-name: regexp # все метрики, имя которых соответствует regexp (опциональный)
      tag-key: regexp # все метрики с тегом, ключ котого соответствуюет regexp (опциональный)
      tag-value: regexp # все метрики с тегом, ключ которого соответствует tag-key и значение, соответствующее regexp (опциональный)
      fixed: [1ms, 2ms... Nms] # фиксированный список бакетов (опциональный)
      generator: # генератор бакетов, генерирует 50 бакетов с более плотным распределением около опорных точек (опциональный)
        left: 1ms # самая левая точка на отрезке (0, ∞), задает минимальное ожидаемое значение элементов гистограммы
        pivot: 5ms # опорная точка на отрезке (left, right), задает наиболее ожидаемое значение элементов гистограммы
        right: 10 ms # самая правая точка на отрезке (pivot, ∞), задает максимальное ожидаемое значение элементов гистограммы
        timeout: 100500ms # самая правая точка на отрезке (right, ∞), задает ожидаемое значение таймаута элементов гистограммы
    name2:
      ...
    ...
    nameN:
      ...
```

Если метрика попадает под условия нескольких конфигураций, то будет выбрана первая из списка.

Требования к конфигурации элементов sla:
 * Обязательно должен быть задан или **metric-name** или **tag-key**
 * Обязательно должен быть задан или **fixed** или **generator**
 * **tag-value** может быть задан только совместно с **tag-key**
 * Параметры генератора должны удовлетворять следующему отношению `0 < left < pivot < right < timeout`
