package ru.yandex.mail.micronaut.micrometer.unistat;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.micrometer.core.instrument.MeterRegistry;
import io.micronaut.configuration.metrics.annotation.RequiresMetrics;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Produces;
import lombok.SneakyThrows;
import lombok.val;

import javax.inject.Inject;
import java.util.concurrent.CompletableFuture;

import static java.util.concurrent.CompletableFuture.completedFuture;

@Controller
@RequiresMetrics
public class UnistatController {
    private final MeterRegistry registry;
    private final ThreadLocal<UnistatSerializer> serializer;

    @Inject
    @SneakyThrows
    public UnistatController(MeterRegistry registry, ObjectMapper objectMapper) {
        val factory = objectMapper.getFactory();

        this.registry = registry;
        this.serializer = ThreadLocal.withInitial(() -> new UnistatSerializer(factory));
    }

    private String serialize() {
        return serializer.get().serialize(registry);
    }

    @Get("/unistat")
    @Produces(MediaType.TEXT_JSON)
    public CompletableFuture<String> unistat() {
        return completedFuture(serialize());
    }
}
