package ru.yandex.mail.micronaut.micrometer.unistat;

import io.micronaut.configuration.metrics.annotation.RequiresMetrics;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Context;
import io.micronaut.core.annotation.Introspected;
import lombok.Data;
import one.util.streamex.StreamEx;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;
import javax.validation.constraints.PositiveOrZero;
import java.time.Duration;

import static java.time.Duration.ofMillis;
import static java.time.Duration.ofMinutes;
import static java.time.Duration.ofSeconds;

@Data
@Context
@Introspected
@RequiresMetrics
@ConfigurationProperties("unistat")
public class UnistatMeterRegistryConfiguration {
    private static long[] convertSla(Duration[] sla) {
        return StreamEx.of(sla)
            .mapToLong(Duration::toNanos)
            .toArray();
    }

    @NotNull @PositiveOrZero private Duration expiry = ofMinutes(1);
    @Positive private int bufferLength = 1000;
    @NotEmpty private Duration[] defaultSla = {
        ofMillis(10),
        ofMillis(15),
        ofMillis(20),
        ofMillis(25),
        ofMillis(30),
        ofMillis(40),
        ofMillis(50),
        ofMillis(70),
        ofMillis(90),
        ofMillis(110),
        ofMillis(130),
        ofMillis(150),
        ofMillis(250),
        ofMillis(300),
        ofMillis(350),
        ofMillis(400),
        ofMillis(500),
        ofMillis(600),
        ofMillis(700),
        ofMillis(800),
        ofMillis(900),
        ofSeconds(1),
        ofSeconds(2),
        ofSeconds(5),
        ofSeconds(10),
        ofSeconds(20),
        ofSeconds(30),
        ofSeconds(60),
        ofSeconds(120)
    };

    public long[] getDefaultSlaNanos() {
        return convertSla(defaultSla);
    }
}
