package ru.yandex.mail.micronaut.tvm;

import io.micronaut.context.annotation.ConfigurationInject;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.convert.format.MapFormat;
import lombok.Getter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Map;

import static ru.yandex.mail.micronaut.tvm.Constants.TVM_PROPERTIES;

@Getter
@Introspected
@ConfigurationProperties(TVM_PROPERTIES)
@Requires(property = "micronaut.security.enabled", value = "true")
public class TvmConfiguration {
    private final String token;
    private final Map<String, Long> services;
    private final Map<String, Long> allowedClients;

    @ConfigurationInject
    public TvmConfiguration(@NotBlank String token, @MapFormat @NotNull Map<String, Long> services,
                            @MapFormat @NotNull Map<String, Long> allowedClients) {
        this.token = token;
        this.services = services;
        this.allowedClients = allowedClients;
    }
}
