package ru.yandex.mail.micronaut.tvm.auth;

import io.micronaut.security.authentication.Authentication;
import lombok.val;
import ru.yandex.mail.micronaut.common.AuthenticationInfo;
import ru.yandex.mail.micronaut.tvm.client.TvmTicket.ServiceTvmTicket;
import ru.yandex.mail.micronaut.tvm.client.TvmTicket.UserTvmTicket;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;

import static java.util.Collections.unmodifiableMap;

public class TvmAuthentication implements Authentication, AuthenticationInfo {
    public static final String SERVICE_TICKET_PROPERTY = "TVM-serviceTicket";
    public static final String USER_TICKET_PROPERTY = "TVM-userTicket";

    private final Map<String, Object> claims;
    private final String serviceName;

    @Nullable
    private UserTvmTicket getUserTicket() {
        return (UserTvmTicket) getAttributes().get(USER_TICKET_PROPERTY);
    }

    @Nonnull
    private ServiceTvmTicket getServiceTicket() {
        return (ServiceTvmTicket) getAttributes().get(SERVICE_TICKET_PROPERTY);
    }

    public TvmAuthentication(String serviceName, ServiceTvmTicket serviceTicket, Optional<UserTvmTicket> userTicket) {
        val map = new HashMap<String, Object>(2);
        map.put(SERVICE_TICKET_PROPERTY, serviceTicket);
        userTicket.ifPresent(ticket -> map.put(USER_TICKET_PROPERTY, ticket));
        this.claims = unmodifiableMap(map);
        this.serviceName = serviceName;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return claims;
    }

    @Override
    public String getName() {
        return serviceName;
    }

    @Override
    public OptionalLong userUid() {
        val ticket = getUserTicket();
        return (ticket == null) ? OptionalLong.empty() : OptionalLong.of(ticket.getDefaultUid());
    }

    @Override
    public String clientName() {
        return getName();
    }

    @Override
    public long clientId() {
        return getServiceTicket().getTvmId();
    }
}
