package ru.yandex.mail.micronaut.tvm.auth;

import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.binders.TypedRequestArgumentBinder;
import lombok.val;

import javax.inject.Singleton;
import java.util.Optional;

@Singleton
public class TvmUidArgumentBinder implements TypedRequestArgumentBinder<TvmUid> {
    private static Optional<TvmUid> extractUid(HttpRequest<?> source) {
        return source.getUserPrincipal(TvmAuthentication.class)
            .map(authentication -> {
                val uidOpt = authentication.userUid();
                return uidOpt.isPresent() ? new TvmUid(uidOpt.getAsLong()) : null;
            });
    }

    private static BindingResult<TvmUid> bind(Optional<TvmUid> uid) {
        return () -> uid;
    }

    @Override
    public Argument<TvmUid> argumentType() {
        return Argument.of(TvmUid.class);
    }

    @Override
    public BindingResult<TvmUid> bind(ArgumentConversionContext<TvmUid> context, HttpRequest<?> source) {
        return bind(extractUid(source));
    }
}
