package ru.yandex.mail.micronaut.tvm.client;

import lombok.EqualsAndHashCode;
import lombok.Value;

import java.util.NoSuchElementException;

public abstract class CheckResult<T extends TvmTicket> {
    protected CheckResult() {}

    public abstract boolean isSuccess();
    public abstract boolean isForbidden();

    public abstract T getTicket();

    public static final CheckResult Forbidden = new CheckResult() {
        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public boolean isForbidden() {
            return true;
        }

        @Override
        public TvmTicket getTicket() {
            throw new NoSuchElementException("There is no valid ticket found");
        }
    };

    @Value
    @EqualsAndHashCode(callSuper = false)
    public static class Success<T extends TvmTicket> extends CheckResult<T> {
        T ticket;

        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        public boolean isForbidden() {
            return false;
        }
    }
}
