package ru.yandex.mail.micronaut.tvm.client;

import io.micronaut.context.annotation.DefaultImplementation;
import reactor.core.publisher.Mono;
import ru.yandex.mail.micronaut.tvm.client.TvmTicket.ServiceTvmTicket;
import ru.yandex.mail.micronaut.tvm.client.TvmTicket.UserTvmTicket;
import ru.yandex.mail.micronaut.tvm.tvmtool.TvmToolClient;

import java.util.Map;

@DefaultImplementation(TvmToolClient.class)
public interface TvmClient {
    Mono<ServiceTvmTicket> getTicketFor(long dst);

    Mono<Map<Long, ServiceTvmTicket>> getTicketsFor(long... dst);

    Mono<CheckResult<ServiceTvmTicket>> checkServiceTicket(String ticket);

    Mono<CheckResult<UserTvmTicket>> checkUserTicket(String ticket);
}
