package ru.yandex.mail.micronaut.tvm.client;

import lombok.EqualsAndHashCode;
import lombok.Value;

public abstract class TvmTicket {
    protected TvmTicket() {}

    public abstract String getPayload();

    @Value
    @EqualsAndHashCode(callSuper = false)
    public static class ServiceTvmTicket extends TvmTicket {
        String payload;
        long tvmId;
    }

    @Value
    @EqualsAndHashCode(callSuper = false)
    public static class UserTvmTicket extends TvmTicket {
        String payload;
        long defaultUid;
    }
}
