package ru.yandex.mail.micronaut.tvm.tvmtool;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Header;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.http.client.annotation.Client;
import io.micronaut.validation.Validated;
import lombok.AllArgsConstructor;
import lombok.Value;
import reactor.core.publisher.Mono;

import javax.annotation.Nullable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;
import java.util.List;
import java.util.Map;

import static ru.yandex.mail.micronaut.tvm.Constants.*;
import static ru.yandex.mail.micronaut.tvm.tvmtool.HttpTvmToolClient.CLIENT_ID;

enum BlackBoxEnvironment {
    PROD,
    TEST,
    PRODYATEAM,
    TESTYATEAM
}

@Value
@Introspected
@AllArgsConstructor(onConstructor_= @JsonCreator)
class CheckServiceResponse {
    long src;
}

@Value
@Introspected
@AllArgsConstructor(onConstructor_= @JsonCreator)
@JsonNaming(value = PropertyNamingStrategy.SnakeCaseStrategy.class)
class CheckUserResponse {
    long defaultUid;
}

@Value
@Introspected
@AllArgsConstructor(onConstructor_= @JsonCreator)
@JsonNaming(value = PropertyNamingStrategy.SnakeCaseStrategy.class)
class TicketResponse {
    @Positive long tvmId;
    @NotBlank String ticket;
}

@Validated
@Requires(property = TVM_TOKEN_PROPERTY)
@Client(id = CLIENT_ID, errorType = String.class)
@Header(name = "Authorization", value = "${" + TVM_TOKEN_PROPERTY + "}")
interface HttpTvmToolClient {
    String CLIENT_ID = "tvm-tool";

    @Get("/tvm/tickets")
    Mono<Map<String, TicketResponse>> tickets(@QueryValue("dsts") @NotEmpty List<@NotNull Long> destinations,
                                              @Nullable @QueryValue("src") Long source);

    default Mono<Map<String, TicketResponse>> tickets(List<Long> destinations) {
        return tickets(destinations, null);
    }

    @Get("/tvm/checksrv")
    Mono<CheckServiceResponse> checkService(@Header(TVM_SERVICE_TICKET_HEADER) @NotBlank String ticket,
                                            @Nullable @QueryValue("dst") Long destination);

    default Mono<CheckServiceResponse> checkService(String ticket) {
        return checkService(ticket, null);
    }

    @Get("/tvm/checkusr")
    Mono<CheckUserResponse> checkUser(@Header(TVM_USER_TICKET_HEADER) @NotBlank String ticket,
                                                   @Nullable @QueryValue("override_env") BlackBoxEnvironment environment);

    default Mono<CheckUserResponse> checkUser(String ticket) {
        return checkUser(ticket, null);
    }
}
