JUNIT5()

JDK_VERSION(11)

OWNER(
    g:fininfra
)

INCLUDE(../../dependency_versions.inc)
INCLUDE(../../test_deps.inc)
INCLUDE(../../micronaut_http_server.inc)

INCLUDE(${ARCADIA_ROOT}/library/recipes/tvmtool/recipe.inc)

USE_RECIPE(
    library/recipes/tvmtool/tvmtool mail/micronaut/tvm/ut/tvmtool.conf
)

IF (SANITIZER_TYPE)
    TAG(ya:not_autocheck)
ENDIF()

JAVAC_FLAGS(
    -parameters
    -Xlint:unchecked
)

NO_LINT()
SIZE(medium)

JAVA_SRCS(SRCDIR ${ARCADIA_ROOT}/mail/micronaut/tvm/src/test/java **/*)
JAVA_SRCS(RESOURCES SRCDIR ${ARCADIA_ROOT}/mail/micronaut/tvm/src/test/resources **/*)

PEERDIR(
    mail/micronaut/tvm
    contrib/java/io/micronaut/test/micronaut-test-junit5
)

ANNOTATION_PROCESSOR(
    lombok.launch.AnnotationProcessorHider$AnnotationProcessor
    io.micronaut.annotation.processing.TypeElementVisitorProcessor
    io.micronaut.annotation.processing.PackageConfigurationInjectProcessor
    io.micronaut.annotation.processing.BeanDefinitionInjectProcessor
)

END()
