#include <mimeparser/Mulca.h>

///@todo FIXME
#include "../tests/File.h"


void usage(const char * argv0)
{
    std::cout << argv0 << " [name of file]" << std::endl;
}

int check_message(const std::string& filename)
{
    using std::string;
    using MimeParser::Mulca::split_meta;
    using MimeParser::Mulca::parse_range;
    typedef boost::iterator_range<std::string::const_iterator> Range;
    File file(filename);
    const string& content=file.contents();
    string::const_iterator it=split_meta(content.begin(), content.end());
    if (content.end()!=it) {
        Range meta=boost::make_iterator_range(content.begin(), it);
        Range body=boost::make_iterator_range(it, content.end());
        std::string newMeta=parse_range(body.begin(), body.end());
        return !boost::equals(meta, newMeta);
    }
    return 1;
}

int main(int argc, char* argv[])
{
    if (1>=argc) {
        usage(argv[0]);
    } else {
        return check_message(argv[1]);
    }
    return 0;
}
