#include <mimeparser/Mulca.h>

#include <iostream>
#include <string>

///@todo FIXME
#include "../tests/File.h"


void usage(const char * argv0)
{
    std::cout << argv0 << "[-e] [name of file]" << std::endl;
    std::cout << "-e - show parsing errors list" << std::endl;
}

void parse(const std::string& filename)
{
    using MimeParser::Mulca::parse_message;
    File file(filename);
    std::cout << parse_message(file.contents());
}

void parseAndShowErrors(const std::string& filename)
{
    using MimeParser::Mulca::parse_message;
    typedef MimeParser::Handlers::MessageHandler<std::string::const_iterator>::ErrorList ErrorList;
    File file(filename);

    ErrorList errors;
    std::cout << parse_message(file.contents(), errors);
    std::cout << "----------------------------------------------------------------------" << std::endl;
    std::cout << "Errors:" << std::endl;
    for(ErrorList::const_iterator it = errors.begin(); it != errors.end(); ++it) {
        std::cout << *it << std::endl;
    }
}

int main(int argc, char* argv[])
{
    if (1>=argc) {
        usage(argv[0]);
    } else {
        if(std::string(argv[1]) != "-e") {
            parse(argv[1]);
        } else {
            if(argc < 3) {
                usage(argv[0]);
            } else {
                parseAndShowErrors(argv[2]);
            }
        }
    }
    return 0;
}
