#!/usr/bin/env bash

# Shows parsing difference in file

FILE=${1}
NAME=`echo ${FILE} | awk -F '/' '{print $NF}'`

check_app="./check_message"
split_app="./split_message"
parse_app="./parse_message"



if ${check_app} "${FILE}"
then
    :
else
    ORIGIN=`mktemp .mimeparser.origin.+${NAME}+.XXXXXXXXXXX`
    ${split_app} "${FILE}" text > "${ORIGIN}"
    OLDMETA=`mktemp .mimeparser.oldmeta.XXXXXXXXXXX`
    ${split_app} "${FILE}" meta > "${OLDMETA}"
    NEWMETA=`mktemp .mimeparser.newmeta.XXXXXXXXXXX`
    ${parse_app} "${ORIGIN}" > "${NEWMETA}"
    echo "[${ORIGIN}]"
    diff -U3 "${OLDMETA}" "${NEWMETA}"
fi
