#ifndef EDP_BODY_LENGTH_H_
#define EDP_BODY_LENGTH_H_

#include <mimeparser/base64.h>
#include <mimeparser/qp.h>

namespace MimeParser {
namespace BodyLength {

template <class Iterator>
class Calculator {
public:
    virtual void push(const Iterator& begin, const Iterator& end)=0;
    virtual size_t length()=0;
    virtual ~Calculator() {}
};

template <class Iterator>
class Plain : public Calculator<Iterator> {
public:
    Plain()
        : m_length(0)
    {}
    virtual void push(const Iterator& begin, const Iterator& end) {
        m_length+=end-begin;
    }
    virtual size_t length() {
        return m_length;
    }
private:
    size_t m_length;
};

template <class Iterator>
class Qp : public Calculator<Iterator> {
public:
    typedef mail::utils::qp::LengthCalculator<Iterator> QpCalculator;
public:
    virtual void push(const Iterator& begin, const Iterator& end) {
        m_qpCalculator.push(begin, end);
    }
    virtual size_t length() {
        m_qpCalculator.stop();
        return m_qpCalculator.length();
    }
private:
    QpCalculator m_qpCalculator;
};

template <class Iterator>
class Base64 : public Calculator<Iterator> {
public:
    typedef mail::utils::base64::LengthCalculator<Iterator> Base64Calculator;
public:
    virtual void push(const Iterator& begin, const Iterator& end) {
        m_base64Calculator.push(begin, end);
    }
    virtual size_t length() {
        m_base64Calculator.stop();
        return m_base64Calculator.length();
    }
private:
    Base64Calculator m_base64Calculator;
};

} // PartLength
} // MimeParser

#endif
