#include <cstddef>
#include <string>

namespace MimeParser {
/**
 * Contains offset of boundary inside string, and status
 */
class BoundaryStatus {
public:
    /**
     * Boundary status of the line.
     */
    typedef enum {
        /// We do not have boundary at current line
        NO_BOUNDARY,
        /// We have usial boundary at current line
        BOUNDARY,
        /// We have final boundary at current line
        FINAL_BOUNDARY
    } EBoundaryStatus;
private:
    typedef EBoundaryStatus BStatus;
public:
    explicit
    BoundaryStatus(BStatus status, size_t nestedLevel=0, size_t offset=0)
        : m_status(status)
        , m_nestedLevel(nestedLevel)
        , m_offset(offset)
    {}
    BStatus status() const {
        return m_status;
    }
    BoundaryStatus& setOffset(size_t offset) {
        m_offset=offset;
        return *this;
    }
    size_t offset() const {
        return m_offset;
    }
    size_t nestedLevel() const {
        return m_nestedLevel;
    }
    static const std::string& delim() {
        return BOUNDARY_DELIMITER;
    }
private:
    BStatus m_status;
    size_t m_nestedLevel;
    size_t m_offset;
    static const std::string BOUNDARY_DELIMITER;
};
}
