#ifndef EDP_CHUNK_H_
#define EDP_CHUNK_H_

#include <boost/range.hpp>

namespace MimeParser {
/**
 * Chunk is a plain uninterraptable memory part
 */
template <class Iterator>
class Chunk {
public:
    typedef Iterator iterator_type;
    typedef boost::iterator_range<iterator_type> Range;
    typedef size_t size_type;
public:
    /*implicit*/
    Chunk(Range range);
    const Range& range() const;
    bool isDangling() const;
    void setDangling();
    size_type& offset();
    const size_type& offset() const;
    size_type size() const;
private:
    Range m_range;
    bool m_isDangling;
    size_type m_offset; // maybe we must to extact it.
};

} //namespace MimeParser

template <class Iterator>
MimeParser::
Chunk<Iterator>::
Chunk(Range range)
    : m_range(range)
    , m_isDangling(false)
    , m_offset(0)
{}

template <class Iterator>
const typename MimeParser::Chunk<Iterator>::Range&
MimeParser::
Chunk<Iterator>::
range() const
{
    return m_range;
}

template <class Iterator>
bool
MimeParser::
Chunk<Iterator>::
isDangling() const
{
    return m_isDangling;
}

template <class Iterator>
void
MimeParser::
Chunk<Iterator>::
setDangling()
{
    m_isDangling=true;
}

template <class Iterator>
typename MimeParser::Chunk<Iterator>::size_type&
MimeParser::
Chunk<Iterator>::
offset()
{
    return m_offset;
}

template <class Iterator>
const typename MimeParser::Chunk<Iterator>::size_type&
MimeParser::
Chunk<Iterator>::
offset() const
{
    return m_offset;
}

template <class Iterator>
typename MimeParser::Chunk<Iterator>::size_type
MimeParser::
Chunk<Iterator>::
size() const
{
    // here we assuming that range has positive size.
    return static_cast
           <
           typename MimeParser::Chunk<Iterator>::size_type
           >
           (m_range.size());
}

#endif
