#ifndef EDP_HEADER_DATA_H_
#define EDP_HEADER_DATA_H_

/// @warning old mimeparser
#include <mimeparser/parameters.h>
#include <mimeparser/rfc2822address.h>

#include <string>
#include <vector>
#include <memory>
#include <boost/range.hpp>

namespace MimeParser {
class HeaderField;
}

namespace rfc2822 {
class rfc2822address;
}

namespace MimeParser {

using HeaderList = mulca_mime::HeaderList;

/**
 * Mulca-oriented header data.
 */
class HeaderData {
public:
    typedef std::vector<HeaderField> HeaderFields;
public:
    HeaderData(bool unfolded);
    const std::string& cType() const;
    const std::string& contentSubtype() const;
    const std::string& boundary() const;
    const std::string& charset() const;
    const mulca_mime::DecodedString& name() const;
    const std::string& content_transfer_encoding() const;
    const std::string& content_disposition() const;
    const mulca_mime::DecodedString& filename() const;
    const std::string& content_id() const;
    const rfc2822::rfc2822address* from() const;
    const rfc2822::rfc2822address* to() const;
    const rfc2822::rfc2822address* cc() const;
    const std::string& messageId() const;
    const HeaderFields& headerFields() const;
    bool isInlineMessage() const;
public:
    bool parseContentType(const HeaderField& headerField);
    bool parseContentDisposition(const HeaderField& headerField);
    bool parseContentTransferEncoding(const HeaderField& headerField);
    bool parseContentId(const HeaderField& headerField);
    bool parseFrom(const HeaderField& headerField);
    bool parseTo(const HeaderField& headerField);
    bool parseCc(const HeaderField& headerField);
    bool parseMessageId(const HeaderField& headerField);
    bool addHeaderField(const HeaderField& headerField);
    void setRawHeaderList(const HeaderList& headers);
private:
    std::string m_contentType;
    std::string m_contentSubtype;
    std::string m_boundary;
    std::string m_charset;
    mulca_mime::DecodedString m_name;
    std::string m_content_transfer_encoding;
    std::string m_content_disposition;
    mulca_mime::DecodedString m_filename;
    std::string m_content_id;
    // down there are old-related mimeparser structures
    std::unique_ptr<rfc2822::rfc2822address> m_from;
    std::unique_ptr<rfc2822::rfc2822address> m_to;
    std::unique_ptr<rfc2822::rfc2822address> m_cc;
    std::string m_messageId;
    std::vector<HeaderField> m_headerFields;
    HeaderList m_rawHeadersList;
};

} // namespace MimeParser

#endif
