#ifndef EDP_HEADER_FIELD_H_
#define EDP_HEADER_FIELD_H_

#include <mimeparser/unfold_iterator.h>
#include <mimeparser/parameters.h>

#include <string>
#include <ctype.h>


namespace MimeParser {

/**
 * This is simple header field splitter/parser.
 */
class HeaderField {
public:
    template <class Iterator>
    HeaderField(const Iterator& begin, const Iterator& end, bool unfold = true);
    HeaderField(const std::string& headerField);
    /**
     * This class do not throw exceptions, so
     * this function will help you determine
     * if the parsing was successful.
     *
     * @return parsing status
     */
    bool isValid() const {
        return m_result;
    }
    /**
     * @return name of header field
     */
    const std::string& name() const {
        return m_name;
    }
    /**
     * @return value of header field
     */
    const std::string& value() const {
        return m_value;
    }
private:
    template <class Iterator>
    bool parseFoldedHeader(const Iterator& begin,
                           const Iterator& end);
    template <class Iterator>
    bool parseNoFoldedHeader(const Iterator& begin,
                             const Iterator& end);
private:
    bool m_result;
    std::string m_name;
    std::string m_value;
};
} // namespace MimeParser




template <class Iterator>
MimeParser::
HeaderField::
HeaderField(const Iterator& begin, const Iterator& end, bool unfold)
{
    if (unfold) {
        m_result=parseFoldedHeader(begin, end);
    } else {
        m_result=parseNoFoldedHeader(begin, end);
    }
}

template <class Iterator>
bool
MimeParser::
HeaderField::
parseFoldedHeader(const Iterator& begin, const Iterator& end)
{
    typedef Unfold<Iterator> Unfolder;
    typedef typename Unfolder::iterator UIterator;
    UIterator ubegin=Unfolder::create(begin, end);
    UIterator uend=Unfolder::create(end, end);
    return parseNoFoldedHeader(ubegin, uend);
}


template <class Iterator>
bool
MimeParser::
HeaderField::
parseNoFoldedHeader(const Iterator& begin, const Iterator& end)
{
    Iterator it=begin;
    while (end!=it && isspace(*it)) {
        ++it;
    }
    if (end==it) {
        return false;
    }
    Iterator nameStart=it;
    while (end!=it && !isspace(*it) && ':'!=*it) {
        ++it;
    }
    if (end==it) {
        return false;
    }
    Iterator nameEnd=it;
    while (isspace(*it) && end!=it) {
        ++it;
    }
    if (':'!=*it) {
        return false;
    }
    m_name.assign(nameStart, nameEnd);

    ++it;
    if (end!=it) {
        m_value.assign(it, end);
    }
    return true;
}

#endif
