#ifndef EDP_HEADER_PARSER_H_
#define EDP_HEADER_PARSER_H_


#include <mimeparser/HeaderHandler.h>
#include <mimeparser/EolParser.h>

namespace MimeParser {
namespace Parsers {

using Handlers::HeaderHandler;


/**
 * Parser for rfc 2822 header.
 *
 * We are always stayng at position after "\n" "\r\n"
 * and trying to proceed next line.
 */
template <class Iterator, class Handler=HeaderHandler<Iterator> >
class HeaderParser {
public:
    typedef boost::iterator_range<Iterator> Range;
    typedef EolParser<Iterator, HeaderParser> MyEolParser;
public:
    HeaderParser(const Iterator& first, Handler& handler);
    void push(const Iterator& last) {
        m_last=last;
        m_eolParser.push(last);
    }
    void stop() {
        /*NO-OP*/ ///@todo release
    }
public:
    bool endOfLine(const Range& range);
private:
    void eolHandler(const Range& range);
    bool isWhitespace(const Iterator& it) {
        return ('\t'==*it || ' '==*it);
    }
private:
    Handler& m_handler;
    /**
     * We need this iterator - it is the last position we have pushed to parser
     * #iterator
     */
    Iterator m_last;
    /**
     * This is an end-of-line parser, it's has an iterator inside, need to use
     * the value of this iterator while calculating an earlier iterator
     * #iterator
     */
    MyEolParser m_eolParser;
    bool m_recallMe;
    bool m_atStart;
    bool m_atEnd;
    /**
     * This is an range of last end-of-line sequence. We not sure,
     * is it an \r\n, or just an \n, so we are using an range here,
     * and we have here 2 iterators
     * #iterator
     */
    Range m_lastEol;
    /**
     * This is start of last field.
     * #iterator
     */
    Iterator m_lastFieldStart;
};

} // namespace Parsers
} // namespace MimeParser

template <class Iterator, class Handler>
MimeParser::Parsers::
HeaderParser<Iterator, Handler>::
HeaderParser(const Iterator& first, Handler& handler)
    : m_handler(handler)
    , m_last(first)
    , m_eolParser(first, *this)
    , m_recallMe(false)
    , m_atStart(true)
    , m_atEnd(false)
    , m_lastEol(first, first)
    , m_lastFieldStart(first)
{}

template <class Iterator, class Handler>
bool
MimeParser::Parsers::
HeaderParser<Iterator, Handler>::
endOfLine(const Range& range)
{
    if (m_atEnd) {
        return true;
    }
    if (m_atStart) {
        m_handler.beginHeader(m_lastFieldStart);
        m_atStart=false;
    }
    if (m_recallMe) {
        eolHandler(m_lastEol);
        m_recallMe=false;
    }
    eolHandler(range);
    m_lastEol=range;
    return true;
}

template <class Iterator, class Handler>
void
MimeParser::Parsers::
HeaderParser<Iterator, Handler>::
eolHandler(const Range& range)
{
    if (m_lastEol.end()==range.begin()) {
        m_handler.endHeader(range.end());
        m_atEnd=true;
    } else if (m_last>range.end()) {
        if (!isWhitespace(range.end())) {
            m_handler.headerField(Range(m_lastFieldStart, range.end()), range);
            m_lastFieldStart=range.end();
        } else {
            /*NO-OP*/
        }
    } else {
        m_recallMe=true;
    }
}

#endif
