#ifndef EDP_HID_H_
#define EDP_HID_H_


#include <string>
#include <vector>

namespace MimeParser {

/**
 * This class implements "hid" concept
 */
class Hid {
public:
    typedef unsigned int PartNumber;
    typedef std::vector<PartNumber> HeaderId;
public:
    /* imlpicit */
    Hid(const std::string& str="1");

    /**
     * Depth of part that hid describes
     */
    size_t depth() const;
    /**
     * Number of last part
     */
    PartNumber length() const;

    /**
     * Increase last part number on 1
     */
    void next();
    /**
     * Change last part number on delta
     */
    void advance(int delta);
    /**
     * Go to deeper level
     */
    void stepDown();
    /**
     * Go to upper level
     */
    void stepUp();

    /**
     * Show usial hid representation
     */
    std::string toString() const;
private:
    void parseHid(const std::string& str);
private:
    HeaderId m_hid;
};
} // namespace MimeParser

#endif
