#ifndef EDP_MESSAGE_STRUCTURE_H_
#define EDP_MESSAGE_STRUCTURE_H_

#include <mimeparser/XmlPartInfo.h>
#include <mimeparser/part.h>
#include <mimeparser/ccnv.h>

#include <vector>
#include <memory>
#include <iostream>
#include <stdexcept>

namespace MimeParser {

class PartTraverser;

/// rename to message structure
/// TODO split
/// release deep copy
class PartStructure {
public:
    /// remove this friendship
    friend class PartTraverser;
public:
    typedef std::vector<PartStructure*> PartStructures;
public:
    PartStructure(PartStructure* father=NULL)
        : m_father(father)
    {}
    ~PartStructure() {
        for (PartStructures::size_type i=0; i<m_childParts.size(); ++i) {
            delete m_childParts[i];
        }
    }
    const XmlPartInfo& info() const {
        return m_xmlPartInfo;
    }
    XmlPartInfo& info() {
        return m_xmlPartInfo;
    }
    // refactror FIXME
    PartStructure& newChild() {
        std::unique_ptr<PartStructure> tempPart(new PartStructure(this));
        Hid hid=m_xmlPartInfo.hid();
        hid.stepDown();
        hid.advance(static_cast<int>(size()));
        m_childParts.push_back(NULL);
        tempPart->info().setHid(hid);
        m_childParts.back()=tempPart.release();
        return *(m_childParts.back());
    }
    const PartStructure& getChild(size_t childNumber) const {
        return *(m_childParts[childNumber]);
    }
    PartStructure& getChild(size_t childNumber) {
        return *(m_childParts[childNumber]);
    }
    size_t size() const {
        return m_childParts.size();
    }
private:
    PartStructure* m_father;
    PartStructures m_childParts;
    XmlPartInfo m_xmlPartInfo;
};

class MessageStructure {
public:
    void setPartStructure(PartStructure* partStructure) {
        m_partStructure.reset(partStructure);
    }
    PartStructure* partStructure() {
        return m_partStructure.get();
    }
    const PartStructure* partStructure() const {
        return m_partStructure.get();
    }
    bool hasStructure() const {
        return NULL!=m_partStructure.get();
    }
private:
    std::unique_ptr<PartStructure> m_partStructure;
};

class PartTraverser {
public:
    PartTraverser(PartStructure* partStructure)
        : m_partStructure(partStructure) {
        /// @tofo FIXME debug
        //if (NULL==m_partStructure) {
        //throw std::runtime_error("NULL==m_partStructure");
        //}
    }
    PartStructure* father() {
        return m_partStructure->m_father;
    }
    PartStructure* self() {
        return m_partStructure;
    }
    void next() {
        PartStructure* father=m_partStructure->m_father;
        unsigned int newNumber=father->info().hid().length()+1;
        m_partStructure=&(father->getChild(newNumber));
    }
    void previous() {
        PartStructure* father=m_partStructure->m_father;
        unsigned int newNumber=father->info().hid().length()-1;
        m_partStructure=&(father->getChild(newNumber));
    }
    void up() {
        m_partStructure=m_partStructure->m_father;
    }
    void down() {
        m_partStructure=&(m_partStructure->getChild(0));
    }
    PartStructure& operator*() {
        return *m_partStructure;
    }
private:
    PartStructure* m_partStructure;
};

// move to helper function
// do it streamer
inline std::string tabs(size_t number)
{
    std::string result;
    for (size_t i=0; i<number; ++i) {
        result.push_back('\t');
    }
    return result;
}

class AttributeWriter {
    // FIXME object -tab number constant
public:
    AttributeWriter(std::ostream& out, size_t tabNumber)
        : m_out(out)
        , m_tabNumber(tabNumber)
    {}
    inline void add(const std::string& name, const std::string& value) {
        if (!value.empty()) {
            m_out << tabs(m_tabNumber);
            m_out << name << "=\"" << mulca_mime::xml10_escape_utf8_string(value) << "\"\n";
        }
    }
private:
    std::ostream& m_out;
    size_t m_tabNumber;
};

// FIXME here -1
inline std::ostream& operator<<(std::ostream& out, const XmlPartInfo& xmlPartInfo)
{
    out << tabs(xmlPartInfo.hid().depth()-1);
    out << "<part "
        << "id=\"" << xmlPartInfo.hid().toString() << "\" "
        << "offset=\"" << xmlPartInfo.offset() << "\" "
        << "length=\"" << xmlPartInfo.length() << "\"\n";
    AttributeWriter attributeWriter(out, xmlPartInfo.hid().depth());
    attributeWriter.add("content_type.type", xmlPartInfo.type());
    attributeWriter.add("content_type.subtype", xmlPartInfo.subtype());
    attributeWriter.add("content_type.charset", xmlPartInfo.charset());
    attributeWriter.add("content_type.name", xmlPartInfo.name());
    attributeWriter.add("content_transfer_encoding", xmlPartInfo.contentTransferEncoding());
    attributeWriter.add("content_disposition.value", xmlPartInfo.contentDisposition());
    attributeWriter.add("content_disposition.filename", xmlPartInfo.filename());
    attributeWriter.add("content_id", xmlPartInfo.contentId());
    out << tabs(xmlPartInfo.hid().depth()-1)
        <<  ">\n";
    return out;
}

// FIXME here -1
inline std::ostream& operator<<(std::ostream& out,
                                const PartStructure& partStructure)
{
    out << partStructure.info();
    size_t partNumber=0;
    for (; partNumber<partStructure.size(); ++partNumber) {
        out << partStructure.getChild(partNumber);
    }
    out << '\n';
    out << tabs(partStructure.info().hid().depth()-1);
    out << "</part>\n";
    return out;
}

inline std::ostream& operator<<(std::ostream& out,
                                const MessageStructure& messageStructure)
{
    out << "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
    out << "<message>\n";
    if (messageStructure.hasStructure()) {
        out << *(messageStructure.partStructure());
    }
    out << "</message>\n";
    return out;
}
} // namespace MimeParser

#endif
