#ifndef EDP_MULCA_H_
#define EDP_MULCA_H_

#include <mimeparser/MessageParser.h>

#include <boost/algorithm/string/predicate.hpp>

#include <sstream>
#include <string>

namespace MimeParser {
namespace Mulca {
typedef Parsers::HeaderHandlerFactory<std::string::const_iterator> StringHeaderHandlerFactory;
/**
 * Parses message
 * @return string with mulca-style xml.
 */
template <class Iterator>
std::string parse_range(const Iterator& begin, const Iterator& end, Parsers::HeaderHandlerFactory<Iterator> headerHandlerFactory=Parsers::HeaderHandlerFactory<Iterator>());
std::string parse_message(const std::string& message, StringHeaderHandlerFactory headerHandlerFactory=StringHeaderHandlerFactory());

/**
 * Parses message & fill list of parsing warnings
 * @return string with mulca-style xml.
 */
template <class Iterator>
std::string parse_range(
    const Iterator& begin
,   const Iterator& end
,   typename Handlers::MessageHandler<Iterator>::ErrorList& errors
,   Parsers::HeaderHandlerFactory<Iterator> headerHandlerFactory=Parsers::HeaderHandlerFactory<Iterator>());
std::string parse_message(
    const std::string& message
,   Handlers::MessageHandler<std::string::const_iterator>::ErrorList& errors
,   StringHeaderHandlerFactory headerHandlerFactory=StringHeaderHandlerFactory());

template <class Iterator>
Iterator split_meta(const Iterator& begin, const Iterator& end);

} // namespace Mulca
} // namespace MimeParser

template <class Iterator>
std::string
MimeParser::Mulca::
parse_range(const Iterator& begin, const Iterator& end, Parsers::HeaderHandlerFactory<Iterator> headerHandlerFactory)
{
    using std::stringstream;
    using namespace MimeParser::Parsers;
    using namespace MimeParser::Handlers;
    typedef MessageHandler<Iterator> DefaultMessageHandler;
    DefaultMessageHandler messageHandler;
    MessageParser<Iterator, DefaultMessageHandler> messageParser(begin, messageHandler, headerHandlerFactory);
    messageParser.push(end);
    messageParser.stop();
    stringstream ss;
    ss << messageHandler.result();
    return ss.str();
}

template <class Iterator>
std::string
MimeParser::Mulca::
parse_range(
    const Iterator& begin
,   const Iterator& end
,   typename MimeParser::Handlers::MessageHandler<Iterator>::ErrorList& errors
,   Parsers::HeaderHandlerFactory<Iterator> headerHandlerFactory)
{
    using std::stringstream;
    using namespace MimeParser::Parsers;
    using namespace MimeParser::Handlers;
    typedef MessageHandler<Iterator> DefaultMessageHandler;
    DefaultMessageHandler messageHandler;
    MessageParser<Iterator
                , DefaultMessageHandler
                , HeaderHandlerFactory<Iterator> >
        messageParser(begin, messageHandler, headerHandlerFactory);
    messageParser.push(end);
    messageParser.stop();
    messageHandler.getErrors(errors);
    stringstream ss;
    ss << messageHandler.result();
    return ss.str();
}

template <class Iterator>
Iterator
MimeParser::Mulca::
split_meta(const Iterator& begin, const Iterator& end)
{
    typedef boost::iterator_range<Iterator> Range;
    Range range=boost::make_iterator_range(begin, end);
    /// @todo get from static variable
    Range result=boost::find_first(range, "</message>\n");
    if (end!=result.begin()) {
        return result.end();
    }
    return end;
}

#endif
