#ifndef EDP_XML_PART_INFO_H_
#define EDP_XML_PART_INFO_H_

#include <mimeparser/Hid.h>
#include <string>


/// @todo FIXME
#include <mimeparser/header.h>
#include <mimeparser/parameters.h>


/// @todo FIXME
/// copy-paste
template <class Iterator>
std::string
handle_content_id(const Iterator& begin, const Iterator& end)
{
    Iterator start=begin;
    while (start<end) {
        if (!isspace(*start)) {
            break;
        }
        ++start;
    }
    if (start>=end) {
        return std::string();
    }
    if ('<'==*start) {
        ++start;
    }
    Iterator id_start=start;
    while (start<end) {
        if ('>'==*start || isspace(*start)) {
            break;
        }
        ++start;
    }
    if (id_start<end) {
        return std::string(id_start, start);
    }
    return std::string();
}

namespace MimeParser {

class XmlPartInfo {
public:
    XmlPartInfo()
        : m_offset(0)
        , m_length(0)
        , m_realLength(0)
    {}
    void setHid(const Hid& hid) {
        m_hid=hid;
    }
    void setOffset(size_t offset) {
        m_offset=offset;
    }
    void setLength(size_t length) {
        m_length=length;
    }
    void setType(const std::string& type) {
        m_type=type;
    }
    void setSubtype(const std::string& subtype) {
        m_subtype=subtype;
    }
    void setCharset(const std::string& charset) {
        m_charset=charset;
    }
    void setName(const mulca_mime::DecodedString& name) {
        m_name=mulca_mime::header::handle_decoded_string(name);
    }
    void setContentTransferEncoding(const std::string& contentTransferEncoding) {
        m_content_transfer_encoding=contentTransferEncoding;
    }
    void setContentDisposition(const std::string& contentDisposition) {
        m_contentDisposition=contentDisposition;
    }
    void setFilename(const mulca_mime::DecodedString& filename) {
        m_filename=mulca_mime::header::handle_decoded_string(filename);
    }
    void setContentId(const std::string& contentId) {
        m_contentId=
            handle_content_id(contentId.begin(), contentId.end());
    }
    void setRealLength(size_t realLength) {
        m_realLength=realLength;
    }

    const Hid& hid() const {
        return m_hid;
    }
    size_t offset() const {
        return m_offset;
    }
    size_t length() const {
        return m_length;
    }
    size_t realLength() const {
        return m_realLength;
    }
    const std::string& type() const {
        return m_type;
    }
    const std::string& subtype() const {
        return m_subtype;
    }
    const std::string& charset() const {
        return m_charset;
    }
    const std::string& name() const {
        return m_name;
    }
    const std::string& contentTransferEncoding() const {
        return m_content_transfer_encoding;
    }
    const std::string& contentDisposition() const {
        return m_contentDisposition;
    }
    const std::string& filename() const {
        return m_filename;
    }
    const std::string& contentId() const {
        return m_contentId;
    }
private:
    Hid m_hid;
    size_t m_offset;
    size_t m_length;
    size_t m_realLength;
    std::string m_type;
    std::string m_subtype;
    std::string m_charset;
    std::string m_name;
    std::string m_content_transfer_encoding;
    std::string m_contentDisposition;
    std::string m_filename;
    std::string m_contentId;
};
} //namespace MimeParser

#endif
