#ifndef _BUILD_MSG_H
#define _BUILD_MSG_H

//#include <mimeparser/config.h>
#include <list>
#include <iostream>
#include <time.h>
#include <ctype.h>
#include <butil/datetime/util_date.h>
#include <butil/butil.h>
#include <mimeparser/rfc2822address.h>
#include <mimeparser/Hid.h>
#include <boost/thread/mutex.hpp>
#include <boost/lexical_cast.hpp>

inline bool
cmpi(const std::string& s1,const std::string&s2)
{
    return tolow(s1)==tolow(s2);
}

template<class T>
class sequence {
public:
    sequence():a()
    {}
    sequence(const T& b):a(b)
    {}
    T next(void) {
        boost::mutex::scoped_lock lock(mutex_);
        a++;
        T t(a);
        return t;
    }
    T operator++() {
        return next();
    }
    T operator++(int) {
        boost::mutex::scoped_lock lock(mutex_);
        T t(a);
        a++;
        return t;
    }
    /// @warning non-static, so only global usage is correct
    boost::mutex mutex_;
    T a;
};

extern sequence<int> int_seq;



class local_hostname {
public:
    local_hostname(void) {
        char buff[1024]="gethostname.failed.ru";
        gethostname(&buff[0],1024);
        hname=buff;
        if (hname.find('.')==hname.npos) {
            hname +=".yandex.ru";
        }
    }
    static const std::string& get(void) {
        return hname;
    }
    static std::string hname;
};


extern local_hostname lh;


inline std::string
generate_message_id(void)
{
    return std::string("<")+boost::lexical_cast<std::string>(int_seq++)+
           boost::lexical_cast<std::string>(time(0))+"@"+local_hostname::get()+">";
}

inline std::string
generate_content_id(void)
{
    return boost::lexical_cast<std::string>(int_seq++)+
           boost::lexical_cast<std::string>(time(0))+"@"+local_hostname::get();
}


std::string
transform_2047(const std::string& name,const std::string& charset,
               const std::string& encod, bool do_on8);

inline std::string fixNewLnInHeaders (const std::string & str) {
    std::string strCopy(str);
    std::string::size_type pos = strCopy.find('\n');
    while (pos != std::string::npos) {
        if (pos == strCopy.length() - 1 || strCopy[pos+1] != '\t') {
            strCopy.insert(pos+1, "\t");
        }
        pos = strCopy.find('\n', pos+1);
    }
    return strCopy;
}

inline std::string
transform_header_field(const std::string& value, const std::string& charset) {
    return transform_2047(fixNewLnInHeaders(value), charset, "base64", true);
}

std::string
transform_email_header_field(const std::string& value,const std::string& charset);
std::string
transform_email_header_draft_field(const std::string& value, const std::string& charset);
std::string
transform_email_header_field_nofolding(const std::string& value,const std::string& charset);



inline bool
have_8bit(const std::string& s)
{
    for (std::string::size_type i=0; i<s.size(); ++i) {
        if (s[i] & 128) {
            return true;
        }
    }
    return false;
}

#define crln "\r\n"

class single_message {
public:
    typedef std::list<std::pair<std::string,std::string> > hdr_list_t;
    single_message(const std::string& charset_): charset(charset_) {
        if (charset.empty()) {
            charset="US-ASCII";
        }
    }

    single_message(single_message&&) = default;

    void set_charset(const std::string& c) {
        charset=c;
    }
    virtual ~single_message()
    {}

    void add_std_message_headers(time_t date=0) {
        add_header("MIME-Version", "1.0");
        add_message_id();
        if (date==0) {
            date=time(0);
        }
        add_time(date);
    }

    void add_message_id(void) {
        // XXX message_id should be set in add_header.
        add_header("Message-Id",message_id=generate_message_id());
    }
    void add_message_id(const std::string& msgid) {
        // XXX message_id should be set in add_header.
        add_header("Message-Id",message_id=msgid);
    }
    std::string get_message_id(void) {
        return message_id;
    }

    void add_cid(const std::string &cid) {
        add_header("Content-Id", cid);
    }

    void add_clocation(const std::string &clocation) {
        add_header("Content-Location", clocation);
    }

    void add_time(time_t tt) {
        struct tm gmt;
        struct tm* rmt=diet_localtime_r(&tt,&gmt);
        char time_str[150]="";
        diet_strftime(time_str,sizeof(time_str)-1,"%a, %d %b %Y %H:%M:%S %z",rmt);
        add_header("Date",time_str);
        date = time_str;
    }

    std::string get_date() {
        return date;
    }

    void add_header(const std::string& n,const std::string& value,
                    const std::string& chr="") {
        hdr_list.push_back(std::make_pair(n,transform_header_field(value,
                                          chr.empty()?charset:chr)));
    }

    void add_email_header_draft(const std::string& n, const std::string& value,
            const std::string& chr="") {
        hdr_list.push_back(std::make_pair(n,
                transform_email_header_draft_field(value, chr.empty()?charset:chr)));
    }

    void add_email_header(const std::string& n,const std::string& value,
            const std::string& chr="")
    {
        hdr_list.push_back(std::make_pair(n,transform_email_header_field(value,
                                chr.empty()?charset:chr)));
    }

    hdr_list_t::iterator headers_begin()
    {
        return hdr_list.begin();
    }

    hdr_list_t::iterator headers_end() {
        return hdr_list.begin();
    }

    hdr_list_t::iterator find_header(const std::string& header) {
        for (hdr_list_t::iterator it = hdr_list.begin(); it != hdr_list.end(); ++it) {
            if (it->first == header) {
                return it;
            }
        }
        return hdr_list.end();
    }

    void remove_header(hdr_list_t::iterator it) {
        hdr_list.erase(it);
    }

    void add_ctype(const std::string& type, const std::string& sybtype,
                   const std::string& name,const std::string& name_charset="") {
        content_type =type+"/"+sybtype;
        if (!charset.empty() && charset!="US-ASCII") {
            content_type += std::string("; charset=")+charset;
        }
        if (!name.empty()) {
            content_type +=";" crln;
            content_type += "\tname=\""+transform_2047(name,
                            name_charset.empty()?charset:name_charset,"base64",true)
                            +"\"";
        }
    }

    void boundary(const std::string& b) {
        boundary_=b;
    }

    std::string boundary(void) {
        return boundary_;
    }

    void add_cdisposition(const std::string& tag, const std::string& name,
                          const std::string& name_charset="") {
        std::string fld(tag);
        if (!name.empty()) {
            fld +=";";
            fld +=crln;
            fld += "\tfilename=\""+transform_2047(name,name_charset.empty()?charset:name_charset,
                                                  "base64",true)
                   +"\"";
        }
        add_header("Content-Disposition",fld);
    }

    static const bool make_cte=true;
    static const bool no_cte=false;

    void add_body(const std::string& text, const std::string& cte, bool do_enc=make_cte) {
        if (cmpi(cte,"base64")) {
            body=do_enc?encode_base64_splitline(text):text;
            add_header("Content-Transfer-Encoding","base64");
        } else if (cmpi(cte,"quoted-printable")) {
            body=do_enc?encode_qp(text):text;
            add_header("Content-Transfer-Encoding","Quoted-Printable");
        } else {
            if (cte.empty()) {
                add_header("Content-Transfer-Encoding","8bit");
            } else {
                add_header("Content-Transfer-Encoding",cte);
            }
            body=text;
        }
    }
    std::string headers(void) {
        std::string temp;
        return headers(temp);
    }
    static bool isContentType(std::pair<std::string, std::string> header) {
        return header.first == "Content-Type";
    }
    std::string& headers(std::string& s) {
        s="";
        if (std::find_if(hdr_list.begin(), hdr_list.end(), isContentType) == hdr_list.end()) {
            generate_ctype();
        }
        for (hdr_list_t::iterator it=hdr_list.begin();
                it!=hdr_list.end(); ++it) {
            s+=it->first;
            s+=": ";
            s+=it->second;
            s+=crln;
        }
        return s;
    }

    virtual std::string text(void) {
        std::string temp;
        return text(temp);
    }
    virtual std::string& text(std::string& s) {
        headers(s);
        s+=crln;
        s+=body;
        return s;
    }

    MimeParser::Hid GetHid() const {
        return m_hid;
    }

    void SetHid(const MimeParser::Hid& hid) {
        m_hid = hid;
    }

private:
    void generate_ctype(void) {
        if (content_type.empty()) {
            add_ctype("text","plain","");
        }
        if (!boundary_.empty()) {
            content_type +=";" crln;
            content_type += "\tboundary=\""+boundary_ +"\"";
        }
        add_header("Content-Type",content_type);
    }
    hdr_list_t hdr_list;
    std::string body;
    std::string charset;
    std::string content_type;
    std::string boundary_;
    std::string message_id;
    std::string date;
    MimeParser::Hid m_hid;
};

class message: public single_message {
public:
    typedef std::list<single_message*> part_list_t;
    message(const std::string& chr = "US-ASCII"): single_message(chr)
    {}

    message(message&&) = default;

    virtual ~message() {
        for (part_list_t::iterator it=part_list.begin(); it!=part_list.end(); ++it) {
            delete *it;
        }
    }
    MimeParser::Hid add_part(single_message* part) {
        MimeParser::Hid hid = NextHid();
        part->SetHid(hid);
        part_list.push_back(part);
        return hid;
    }

    MimeParser::Hid add_part(const std::string& type,const std::string& subtype,
                             const std::string& charset, const std::string& text,
                             const std::string& cte,const std::string& name,
                             const std::string& disp, const std::string &content_id,
                             const std::string &content_location, bool do_enc=make_cte,
                             const std::string& name_charset="") {
        single_message* part = new single_message(charset);
        part->add_ctype(type,subtype,name,name_charset);
        if (!disp.empty()) {
            part->add_cdisposition(disp,name,name_charset);
        }
        if (!content_id.empty()) {
            part->add_cid(content_id);
        }
        if (!content_location.empty()) {
            part->add_clocation(content_location);
        }
        part->add_body(text,cte,do_enc);
        return add_part(part);
    }

    //old version
    MimeParser::Hid add_part(const std::string& type,const std::string& subtype,
                             const std::string& charset, const std::string& text,
                             const std::string& cte,const std::string& name, const std::string& disp,
                             bool do_enc=make_cte,const std::string& name_charset="") {
        return add_part(type, subtype, charset, text, cte, name, disp, "", "",
                        do_enc, name_charset);
    }

    void preamble(const std::string& s) {
        preamble_=s;
    }
    void epilogue(const std::string& s) {
        epilogue_=s;
    }
    std::string preamble(void) {
        return preamble_;
    }
    std::string epilogue(void) {
        return epilogue_;
    }
    virtual std::string text(void) {
        std::string temp;
        return text(temp);
    }
    virtual std::string& text(std::string& s) {
        if (part_list.empty()) {
            return single_message::text(s);
        }
        boundary(generate_boundary());
        headers(s);
        s+=crln;
        s+=preamble();
        //
        //
        for (part_list_t::iterator it=part_list.begin(); it!=part_list.end(); ++it) {
            s+=crln;
            s+="--"+boundary()+crln;
            s+=(*it)->text();
        }
        //
        //
        s+=crln;
        s+="--"+boundary()+"--"+crln;
        s+=epilogue();
        return s;
    }
private:
    std::string generate_boundary(void) {
        return "----==--bound."+boost::lexical_cast<std::string>(int_seq++)+"."+local_hostname::get();
    }

    MimeParser::Hid NextHid() {
        MimeParser::Hid newHid;
        if (part_list.empty()) {
            newHid = GetHid();
            newHid.stepDown();
        } else {
            newHid = part_list.back()->GetHid();
            newHid.next();
        }
        return newHid;
    }

    part_list_t part_list;
    std::string preamble_;
    std::string epilogue_;
};

#endif
